
//general
m3              = 2.5 /2;
m3_head_r       = 6 /2;
m3_head_h       = 2;

tol             = 0.05;

//profil
profil_w        = 20;
profil_h        = 20;
profil_nut      = 6;

//wheel
wheel_hole_r    = 5 /2 -tol;
wheel_r         = 24.4 /2;
wheel_h         = 11;
wheel_offset_y  = wheel_r*2 +profil_w -2.2;
wheel_offset_x  = 70;


//baseplate
thickness       = 4;





module wheel() {
    color("grey"){
      translate([0,0,-(profil_h+2 -wheel_h)/2 -wheel_h]){
        difference() {
        cylinder($fn=50, wheel_h, wheel_r, wheel_r);
          translate([0,0,-1])
            cylinder($fn=50, wheel_h+2 , wheel_hole_r, wheel_hole_r);
        }
      }
    }
}

module wheelInsertA() {
    translate([0,0,-(profil_h+2 -wheel_h)/2 -wheel_h]) {
        difference() {
          union() {
          cylinder($fn=50, wheel_h, wheel_hole_r, wheel_hole_r);
            translate([0,0,wheel_h])
              cylinder($fn=50, (profil_h+2 -wheel_h)/2 , wheel_hole_r+2, wheel_hole_r+2);
          }
            translate([0,0,-1])
              cylinder($fn=50, wheel_h +(profil_h+2 -wheel_h)/2 +2, 1.6, 1.6);
        }
    }
}

module wheelInsertB() {
    translate([0,0,-(profil_h+2 -wheel_h) -wheel_h*2 ]) {
        difference() {
          union() {
            translate([0,0,wheel_h])
              cylinder($fn=50, (profil_h+2 -wheel_h)/2 , wheel_hole_r+2, wheel_hole_r+2);
          }
            // screw hole
            translate([0,0,-1])
              cylinder($fn=50, wheel_h +(profil_h+2 -wheel_h)/2 +2, 1.6, 1.6);
        }
    }
}

module baseplateConnector() {
    difference() {
      union() {
        translate([-(wheel_hole_r+2),0,0])
          cube([ (wheel_hole_r+2)*2, wheel_offset_y, thickness]);
        cylinder($fn=50, thickness , wheel_hole_r+2, wheel_hole_r+2);
        translate([0,wheel_offset_y,0])
          cylinder($fn=50, thickness , wheel_hole_r+2, wheel_hole_r+2);  
      }
      translate([0,0,-1])
        cylinder($fn=50, thickness+2, 1.6, 1.6);
      translate([0,wheel_offset_y,-1])
        cylinder($fn=50, thickness+2, 1.6, 1.6);

      // screw head
      translate([0,0,-1])
        cylinder($fn=50, m3_head_h +1, m3_head_r, m3_head_r);
      translate([0,wheel_offset_y,-1])
        cylinder($fn=50, m3_head_h +1, m3_head_r, m3_head_r);      
       
    }

    
}

module baseplate() {
  difference() {
    cube([wheel_offset_x, wheel_offset_y -(wheel_hole_r+2)*2, thickness]);
    
    translate([5, (wheel_offset_y -(wheel_hole_r+2)*2)*0.5 -3.5 ,-1])  
      cube([3,7, thickness+2]);
    translate([wheel_offset_x -5 -3, (wheel_offset_y -(wheel_hole_r+2)*2)*0.5 -3.5 ,-1])  
      cube([3,7, thickness+2]);
    
  }
}


//SIDE LEFT
//wheelInsertA();
wheelInsertB();
//wheel();
//baseplateConnector();

translate([0,wheel_offset_y,0]){
  //wheel();
  //wheelInsertA();    
  wheelInsertB();
}

translate([0,0,-(profil_h+2 -wheel_h) -wheel_h-thickness]) {
  baseplateConnector();
  translate([0,(wheel_hole_r+2),0]) {
    baseplate();      
  }
}




// top addition

addition_w = profil_w +thickness*2.5;

/*
translate([0,(wheel_hole_r+2),0]) {
  baseplate();
  translate([ (wheel_offset_x*0.5) -(addition_w)*0.5 ,-(wheel_hole_r+2)*2,0])
    cube([addition_w,(wheel_hole_r+2)*2,thickness]);
  difference() {
    translate([ (wheel_offset_x*0.5) -(addition_w)*0.5 ,-(wheel_hole_r+2)*2,-(profil_h+2   -wheel_h)/2 -5])
      cube([addition_w,thickness,(profil_h+2 -wheel_h)/2 +5]);

        //m3 bohrlöcher
      rotate([90,0,0])
        translate([ (wheel_offset_x*0.5) -(profil_w)*0.5 ,(-(profil_h+2 -wheel_h)/2)*0.5 -2.5,-10])
          cylinder($fn=50, 50, 2.5, 2.5);
      
      rotate([90,0,0])
        translate([ (wheel_offset_x*0.5) +(profil_w)*0.5 ,(-(profil_h+2 -wheel_h)/2)*0.5 -2.5,-10])
          cylinder($fn=50, 50, 2.5, 2.5);
  }
}
*/

// bottom addition

translate([0,(wheel_hole_r+2),-(profil_h+2 -wheel_h) -wheel_h-thickness]) {
  translate([ (wheel_offset_x*0.5) -(addition_w)*0.5 ,-(wheel_hole_r+2)*2,])
    cube([addition_w,(wheel_hole_r+2)*2,thickness]);
  difference() {
    translate([ (wheel_offset_x*0.5) -(addition_w)*0.5 ,-(wheel_hole_r+2)*2,
      thickness ])
      cube([addition_w,thickness,(profil_h+2 -wheel_h)/2 +5]);

        //m3 bohrlöcher
      rotate([90,0,0])
        translate([ (wheel_offset_x*0.5) -(profil_w)*0.5 ,thickness*2 +1.5,-10])
          cylinder($fn=50, 50, 2.5, 2.5);
      
      rotate([90,0,0])
        translate([ (wheel_offset_x*0.5) +(profil_w)*0.5 ,thickness*2 +1.5,-10])
          cylinder($fn=50, 50, 2.5, 2.5);
  }
}





//SIDE RIGHT
translate([wheel_offset_x,0,0]){

//wheelInsertA();
wheelInsertB();
//wheel();
//baseplateConnector();

translate([0,wheel_offset_y,0]){
  //wheel();
  //wheelInsertA();    
  wheelInsertB();
}

translate([0,0,-(profil_h+2 -wheel_h) -wheel_h-thickness])
  baseplateConnector();

}






/*

translate([-(wheel_hole_r+2) +1.5,wheel_offset_y*0.5 -5,-(profil_h+2 -wheel_h) -wheel_h-thickness])
  rotate([-90,0,0])

for (i=[0:3]) {
  translate([i*2,0,0]) {

    linear_extrude(10) polygon([[0.747183,-0.5],[0.747183,0],[0.647876,0.037218],[0.598311,0.130528],[0.578556,0.238423],[0.547158,0.343077],[0.504649,0.443762],[0.451556,0.53975],[0.358229,0.636924],[0.2484,0.707276],[0.127259,0.750044],[0,0.76447],[-0.127259,0.750044],[-0.2484,0.707276],[-0.358229,0.636924],[-0.451556,0.53975],[-0.504797,0.443762],[-0.547291,0.343077],[-0.578605,0.238423],[-0.598311,0.130528],[-0.648009,0.037218],[-0.747183,0],[-0.747183,-0.5]]);


  }
}

*/